// Używa metod dostepowych dla składowych prywatnych. 
 
// Klasa reprezentująca obiekt dwuwymiarowy. 
class TwoDShape { 
  private double width;  // te składowe 
  private double height; // są teraz prywatne 
 
  // Metody dostępowe dla składowych prywatnych width i height. 
  double getWidth() { return width; } 
  double getHeight() { return height; } 
  void setWidth(double w) { width = w; } 
  void setHeight(double h) { height = h; } 
 
  void showDim() { 
    System.out.println("Szerokość i wysokość: " + 
                       width + " and " + height); 
  } 
} 
 
// Klasa pochodna klasy bazowej TwoDShape reprezentująca trójkąty. 
class Triangle extends TwoDShape { 
  String style; 
   
  double area() { 
    return getWidth() * getHeight() / 2;  
  } 
 
  void showStyle() { 
    System.out.println("Trójkąt jest " + style); 
  } 
} 
 
class Shapes2 { 
  public static void main(String args[]) { 
    Triangle t1 = new Triangle(); 
    Triangle t2 = new Triangle(); 
 
    t1.setWidth(4.0); 
    t1.setHeight(4.0); 
    t1.style = "wypełniony"; 
 
    t2.setWidth(8.0); 
    t2.setHeight(12.0); 
    t2.style = "pusty"; 
 
    System.out.println("Informacje o t1: "); 
    t1.showStyle(); 
    t1.showDim(); 
    System.out.println("Powierzchnia wynosi " + t1.area()); 
 
    System.out.println(); 
 
    System.out.println("Informacje o t2: "); 
    t2.showStyle(); 
    t2.showDim(); 
    System.out.println("Powierzchnia wynosi " + t2.area()); 
  } 
}
