/* 
   Przykład 5-2 
 
   Klasa implementująca kolejkę znaków. 
*/ 
 
class Queue { 
  char q[]; // tablica przechowująca kolejkę 
  int putloc, getloc; // indeksy operacji put i get
 
  Queue(int size) { 
    q = new char[size]; // przydziela pamięć kolejce 
    putloc = getloc = 0; 
  } 
 
  // wstawia znak do kolejki 
  void put(char ch) { 
    if(putloc==q.length) { 
      System.out.println(" -- Kolejka pełna."); 
      return; 
    } 
     
    q[putloc++] = ch; 
  } 
 
  // pobiera znak z kolejki 
  char get() { 
    if(getloc == putloc) { 
      System.out.println(" -- Kolejka pusta."); 
      return (char) 0;  
    } 
   
    return q[getloc++]; 
  } 
} 
 
// Demonstruje wykorzystanie klasy Queue. 
class QDemo { 
  public static void main(String args[]) { 
    Queue bigQ = new Queue(100); 
    Queue smallQ = new Queue(4); 
    char ch; 
    int i; 
 
    System.out.println("Używam kolejki bigQ do przechowania alfabetu."); 
    // umieszcza znaki alfabetu w bigQ 
    for(i=0; i < 26; i++) 
      bigQ.put((char) ('A' + i)); 
 
    // pobiera elementy bigQ i wyświetla je
    System.out.print("Zawartość kolejki bigQ: "); 
    for(i=0; i < 26; i++) {  
      ch = bigQ.get(); 
      if(ch != (char) 0) System.out.print(ch); 
    } 
 
    System.out.println("\n"); 
 
 
    System.out.println("Używam kolejki smallQ do wygenerowania błędów."); 
    // Now, use smallQ to generate some errors 
    for(i=0; i < 5; i++) { 
      System.out.print("Próbuję umieścić w kolejce znak " + 
                       (char) ('Z' - i)); 
 
      smallQ.put((char) ('Z' - i)); 
 
      System.out.println(); 
    } 
    System.out.println(); 
 
    // następne błędy kolejki smallQ 
    System.out.print("Zawartość kolejki smallQ: "); 
    for(i=0; i < 5; i++) {  
      ch = smallQ.get(); 
 
      if(ch != (char) 0) System.out.print(ch); 
    } 
  } 
}
