// Prezentacja kontrolki ListView
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.geometry.*; 
import javafx.beans.value.*; 
import javafx.collections.*; 
 
public class ListViewDemo extends Application { 
 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Uruchamia aplikacj JavaFX, wywoujc metod launch(). 
    launch(args);   
  } 
 
  // Przesonicie metody start(). 
  public void start(Stage myStage) { 
 
    // Okrela tytu obszaru roboczego. 
    myStage.setTitle("Prezentacja kontrolki ListView"); 
 
    // Jako korze zostaje uyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstpy pomidzy umieszczonymi
    // w nim kontrolkami bd wynosi 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrwnuje kontrolki do rodka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 200, 120); 
 
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene); 
 
    // Tworzy etykiet. 
    response = new Label("Wybierz typ komputera"); 
 
    // Tworzy list ObservableList, zawierajc elementy, ktre
    // maj by wywietlone w kontrolce listy. 
    ObservableList<String> computerTypes = 
      FXCollections.observableArrayList("Smartfon", "Tablet", "Notebook", 
                                        "Stacjonarny" );  
 
    // Tworzy kontrolk ListView
    ListView<String> lvComputers = new ListView<String>(computerTypes); 
 
    // Okrela preferowan wysoko i szeroko.
    lvComputers.setPrefSize(100, 70); 
 
    // Pobiera model zaznaczania elementw listy.
    MultipleSelectionModel<String> lvSelModel = 
                                     lvComputers.getSelectionModel(); 
 
    // Tworzy obiekt nasuchujcy zdarze, ktry bdzie odpowiada na 
    // zmiany zaznaczenia elementw listy.
    lvSelModel.selectedItemProperty().addListener( 
                                      new ChangeListener<String>() { 
      public void changed(ObservableValue<? extends String> changed, 
                          String oldVal, String newVal) { 
 
        // Wywietla nazw wybranego elementu listy. 
        response.setText("Wybranym typem komputera jest: " + newVal); 
      } 
    }); 
 
    // Dodaje etykiet i kontrolk listy do grafu sceny.
    rootNode.getChildren().addAll(lvComputers, response); 
 
    // Wywietla scen i obszar roboczy. 
    myStage.show(); 
  } 
}
