// Demonstruje prost list JList. 
// Wymaga JDK 7 lub nowszej wersji.
  
import javax.swing.*;  
import javax.swing.event.*; 
import java.awt.*; 
import java.awt.event.*; 
   
class ListDemo implements ListSelectionListener {  
  
  JList<String> jlst; 
  JLabel jlab; 
  JScrollPane jscrlp; 
 
  // Tworzy tablic imion. 
  String names[] = { "Ewa", "Janina", "Robert",  
                     "Sandra", "Joanna",  "Rafa", 
                     "Bolek", "Maria", "Krzysio", 
                     "Andrzej", "Maciej", "Tomek" }; 
 
  ListDemo() {  
    // Tworzy kontener JFrame.  
    JFrame jfrm = new JFrame("Lista JList");  
 
    // Wybiera FlowLayout jako menedera ukadu. 
    jfrm.setLayout(new FlowLayout());  
 
    // Nadaje oknu pocztkowe rozmiary.  
    jfrm.setSize(200, 160);  
  
    // Aplikacja zakoczy dziaanie na skutek zamknicia okna.  
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);  
  
    // Tworzy list JList. 
    jlst = new JList<String>(names); 
 
    // Okrela tryb wyboru. 
    jlst.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
 
    // Opakowuje list kontnerem JScrollPane. 
    jscrlp = new JScrollPane(jlst); 
 
    // Okrela preferowany rozmiar kontenera przewijajcego. 
    jscrlp.setPreferredSize(new Dimension(120, 90)); 
 
    // Tworzy etykiet, ktra bdzie wywietla tekst zachty
    // lub wybrane imi. 
    jlab = new JLabel("Wybierz imi"); 
 
    // Dodaje obiekty nasuchujce zdarze listy. 
    jlst.addListSelectionListener(this); 
 
    // Umieszcza list i etykiet w panelu zawartoci. 
    jfrm.add(jscrlp); 
    jfrm.add(jlab); 
  
    // Wywietla okno.  
    jfrm.setVisible(true);  
  }  
 
  // Obsuguje zdarzenia listy. 
  public void valueChanged(ListSelectionEvent le) {  
    // Pobiera indeks elementu. 
    int idx = jlst.getSelectedIndex(); 
 
    // Wywietla imi, jeli element zosta wybrany. 
    if(idx != -1) 
      jlab.setText("Aktualny wybr: " + names[idx]); 
    else // W przeciwnym razie ponawia zacht. 
      jlab.setText("Wybierz imi"); 
  }  
 
  public static void main(String args[]) {  
    // Tworzy okno w wtku rozdziau zdarze.  
    SwingUtilities.invokeLater(new Runnable() {  
      public void run() {  
        new ListDemo();  
      }  
    });   
  }  
}
