// Prosty przykad klasy sparametryzowanej.  
// T jest parametrem oznaczajcym typ 
// i zostanie zastpiony rzeczywistym typem 
// podczas tworzenia obiektu typu Gen. 
class Gen<T> { 
  T ob; // deklaruje obiekt typu T 
   
  // Konstruktor otrzymuje referencj  
  // obiektu typu T. 
  Gen(T o) { 
    ob = o; 
  } 
 
  // Zwraca ob. 
  T getob() { 
    return ob; 
  } 
 
  // Wywietla typ T. 
  void showType() { 
    System.out.println("Typem T jest " + 
                       ob.getClass().getName()); 
  } 
} 
 
// Demonstruje uycie klasy sparametryzowanej. 
class GenDemo { 
  public static void main(String args[]) { 
    // Tworzy referencj typu Gen, ktrego parametrem
    // jest typ Integer.  
    Gen<Integer> iOb;  
 
    // Tworzy obiekt Gen<Integer> i przypisuje jego referencj 
    // zmiennej iOb.  Zwr uwag na zastosowanie automatycznego  
    // opakowania wartoci 88 obiektem Integer. 
    iOb = new Gen<Integer>(88); 
 
    // Wywietla typ danych uywany przez iOb. 
    iOb.showType(); 
 
    // Pobiera warto iOb. Zwr uwag, e rzutowaniwe nie jest 
    // potrzebne w tym przypadku. 
    int v = iOb.getob(); 
    System.out.println("warto: " + v); 
 
    System.out.println(); 
 
    // Tworzy obiekt Gen wykorzystujcy typ String. 
    Gen<String> strOb = new Gen<String>("Test typw sparametryzowanych"); 
 
    // Wywietla typ danych uywany przez strOb. 
    strOb.showType(); 
 
    // Pobiera warto iOb. Zwr uwag, e znowu rzutowaniwe 
    // nie jest potrzebne. 
    String str = strOb.getob(); 
    System.out.println("warto: " + str); 
  } 
}
