// Kolejka znakw o staym rozmiarze wykorzystujca wyjtki. 
class FixedQueue implements ICharQ {  
  private char q[]; // tablica przechowujca elementy kolejki
  private int putloc, getloc; // indeksy operacji put i get 
     
  // Tworzy pust kolejk o podanym rozmiarze. 
  public FixedQueue(int size) {  
    q = new char[size]; // przydziela pami kolejce 
    putloc = getloc = 0;     
  }     
    
  // Umieszcza znak w kolejce. 
  public void put(char ch) 
    throws QueueFullException { 
 
    if(putloc==q.length)  
      throw new QueueFullException(q.length); 

    q[putloc++] = ch; 
  }     

  // Pobiera znak z kolejki. 
  public char get() 
    throws QueueEmptyException {     
 
    if(getloc == putloc)  
      throw new QueueEmptyException(); 
       
    return q[getloc++];     
  }     
}
