/* Wersja programu CopyFile wykorzystujca instrukcj try.
   zarzdzajc zasobami. Demnstruje zarzdzanie dwoma zasobami
  (w tym przypadku plikami) za pomoc pojedynczej instrukcji try.

   Uwaga: ten kod wymaga uycia JDK 7 lub nowszej wersji.
*/

import java.io.*;

class CopyFile2 {
  public static void main(String args[]) throws IOException 
  {
    int i;

    // First, confirm that both files has been specified.
    if(args.length != 2) {
      System.out.println("Sposb uycia: CopyFile2 rdo Cel");
      return;
    }

    // Otwiera i zamyka dwa pliki za porednictwem instrukcji try.
    try (FileInputStream fin = new FileInputStream(args[0]);
         FileOutputStream fout = new FileOutputStream(args[1]))
    {

      do {
        i = fin.read();
        if(i != -1) fout.write(i);
      } while(i != -1);

    } catch(IOException exc) {
      System.out.println("Bd wejcia/wyjcia: " + exc);
    }
  }
}
