/*
     Przykad 15.1

     Program porwnujcy pliki
     z interfejsem uytkownika
     wykorzystujcym Swing.

     Ta wersja zawiera pole wyboeru, ktrego zaznaczenie
     powoduje wywietlenie pozycji, na ktrej
     zawarto plikw rni si.     

     Wymaga JDK 7 lub nowszej wersji.
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

class SwingFC implements ActionListener {

  JTextField jtfFirst;  // przechowuje nazw pierwszego pliku
  JTextField jtfSecond; // przechowuje nazw drugiego pliku

  JButton jbtnComp; // przycisk porwnania plikw

  JLabel jlabFirst, jlabSecond; // wywietlaj zachty
  JLabel jlabResult; // wywietla wynik i komunikaty o bdach

  JCheckBox jcbLoc; // okrela czy wyswietli informacj o pozycji, 
                    // na ktrej wystpia rnica

  SwingFC() {

    // Tworzy nowy kontener JFrame.
    JFrame jfrm = new JFrame("Porwnywanie plikw");

    // Wybiera FlowLayout jako menedera ukadu.
    jfrm.setLayout(new FlowLayout());

    // Nadaje oknu pocztkowe rozmiary.
    jfrm.setSize(200, 220);

    // Aplikacja zakoczy dziaanie na skutek zamknicia okna.
    jfrm.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    // Tworzy pola tekstowe do wprowadzania nazw plikw.
    jtfFirst = new JTextField(14);
    jtfSecond = new JTextField(14);

    // Wie tekst z tymi polami.
    jtfFirst.setActionCommand("plikA");
    jtfSecond.setActionCommand("plikB");

    // Tworzy przycisk Porwnaj.
    JButton jbtnComp = new JButton("Porwnaj");

    // Dodaje suchacza zdarze przycisku Porwnaj.
    jbtnComp.addActionListener(this);

    // Tworzy etykiety.
    jlabFirst = new JLabel("Pierwszy plik: ");
    jlabSecond = new JLabel("Drugi plik: ");
    jlabResult = new JLabel("");

    // Tworzy pole wyboru.
    jcbLoc = new JCheckBox("Poka pozycj niezgodnoci");

    // Umieszcza komponenty w panelu zawartoci.
    jfrm.add(jlabFirst);
    jfrm.add(jtfFirst);
    jfrm.add(jlabSecond);
    jfrm.add(jtfSecond);
    jfrm.add(jcbLoc);
    jfrm.add(jbtnComp);
    jfrm.add(jlabResult);

    // Wywietla okno
    jfrm.setVisible(true);
  }

  // Porwnuje pliki gdy uytkownik nacinie przycisk Porwnaj.
  public void actionPerformed(ActionEvent ae) {
    int i=0, j=0;
    int count = 0;

    // Najpierw sprawdza czy wprowadzone zostay nazwy
    // obu plikw.
    if(jtfFirst.getText().equals("")) {
      jlabResult.setText("Brak nazwy pierwszego pliku.");
      return;
    }
    if(jtfSecond.getText().equals("")) {
      jlabResult.setText("Brak nazwy drugiego pliku.");
      return;
    }

    // Porwnuje pliki. Uywa rozszerzonej instrukcji try do zarzdzania plikami.
    try (FileInputStream f1 = new FileInputStream(jtfFirst.getText());
         FileInputStream f2 = new FileInputStream(jtfSecond.getText()))
    {
      // Porwnuje zawarto plikw.
      do {
        i = f1.read();
        j = f2.read();
        if(i != j) break;
        count++;
      } while(i != -1 && j != -1);

      if(i != j) {
        if(jcbLoc.isSelected())
          jlabResult.setText("Pliki rni si na pozycji " + count);
        else
          jlabResult.setText("Pliki s rne.");
      }
      else
        jlabResult.setText("Pliki s takie same.");

    } catch(IOException exc) {
      jlabResult.setText("Bd dostpu do pliku.");
    }
  }

  public static void main(String args[]) {
    // Tworzy okno w wtku rozdziau zdarze.
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new SwingFC();
      }
    });
  }
}
