// Prezentacja stosowania pl tekstowych. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class TextFieldDemo extends Application { 
 
  TextField tf; 
  Label response; 
 
  public static void main(String[] args) { 
 
    // Uruchamia aplikacj JavaFX, wywoujc metod launch(). 
    launch(args);   
  } 
 
  // Przesonicie metody start(). 
  public void start(Stage myStage) { 
 
    // Okrela tytu obszaru roboczego. 
    myStage.setTitle("Prezentacja pola tekstowego"); 
 
    // Jako korze zostaje uyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstpy pomidzy umieszczonymi
    // w nim kontrolkami bd wynosi 10. 
    FlowPane rootNode = new FlowPane(10, 10); 
 
    // Wyrwnuje kontrolki do rodka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 230, 140); 
 
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene); 
 
    // Tworzy etykiet pola tekstowego.
    response = new Label("Jak masz na imi: "); 
 
    // Tworzy przycisk do pobierania tekstu.
    Button btnGetText = new Button("Pobierz imi"); 
 
    // Tworzy pole tekstowe.
    tf = new TextField(); 
 
    // Okrela komunikat informacyjny.
    tf.setPromptText("Wpisz imi."); 
 
    // Podaje preferowan liczb kolumn  wielko pola.
    tf.setPrefColumnCount(15); 
 
    // Uywamy wyraenia lambda do obsugi zdarze action
    // generowanych przez pole tekstowe. Zdarzenia te s 
    // generowane, gdy uytkownik nacinie klawisz ENTER
    // podczas wpisywania tekstu w polu. W tym przypadku obsuga
    // zdarzenia sprowadza si do pobrania i wywietlenia 
    // wpisanego imienia.
    tf.setOnAction( (ae) -> response.setText("Nacinito ENTER. " + 
                                "Wpisane imi to: " + tf.getText())); 
 
    // Wyraenia lambda uywamy take do pobrania i wywietlenia 
    // imienia po klikniciu przycisku.
    btnGetText.setOnAction((ae) -> 
                            response.setText("Kliknito przycisk. " + 
                                "Wpisane imi to: " + tf.getText())); 
 
    // Uywa separatora, aby adniej rozmieci elementy 
    // w ukadzie.
    Separator separator = new Separator(); 
    separator.setPrefWidth(180); 
 
    // Dodaje etykiet i kontrolk listy do grafu sceny.
    rootNode.getChildren().addAll(tf, btnGetText, separator, response); 
 
    // Wywietla scen i obszar roboczy. 
    myStage.show(); 
  } 
}
