// Prezentacja obrotu, skalowania, odbicia i zamazania.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
import javafx.scene.transform.*; 
import javafx.scene.effect.*; 
import javafx.scene.paint.*; 
  
public class EffectsAndTransformsDemo extends Application {  
  
  double angle = 0.0; 
  double scaleFactor = 0.4; 
  double blurVal = 1.0; 
 
  // Tworzy i inicjuje efekty i transformacje. 
  Reflection reflection = new Reflection(); 
  BoxBlur blur = new BoxBlur(1.0, 1.0, 1); 
  Rotate rotate = new Rotate(); 
  Scale scale = new Scale(scaleFactor, scaleFactor); 
 
  // Tworzy przyciski. 
  Button btnRotate = new Button("Obr");  
  Button btnBlur = new Button("Zama"); 
  Button btnScale = new Button("Przeskaluj"); 
 
  Label reflect = new Label("Odbicie jest zachwycajce"); 
 
  public static void main(String[] args) {  
  
    // Uruchamia aplikacj JavaFX, wywoujc metod launch(). 
    launch(args);    
  }  
  
  // Przesonicie metody start(). 
  public void start(Stage myStage) {  
  
    // Okrela tytu obszaru roboczego.
    myStage.setTitle("Prezentacja efektw i transformacji");  
  
    // Jako korze zostaje uyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstpy pomidzy umieszczonymi
    // w nim kontrolkami bd wynosi 10. 
    FlowPane rootNode = new FlowPane(20, 20);  
  
    // Wyrwnuje kontrolki do rodka.
    rootNode.setAlignment(Pos.CENTER);  
  
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 300, 120);  
  
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene);  
 
    // Dodaje obrt do listy transformacji przycisku "Obrt".
    btnRotate.getTransforms().add(rotate);  
 
    // Dodaje skalowanie do listy transformacji przycisku "Skalowanie".
    btnScale.getTransforms().add(scale); 
 
    // Dodaje odbicie do listy efektw etykiety.
    reflection.setTopOpacity(0.7); 
    reflection.setBottomOpacity(0.3); 
    reflect.setEffect(reflection); 
 
    // Obsuga zdarze przycisku "Obrt".
    btnRotate.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Kade kliknicie przycisku powoduje powikszenie konta
        // obrotu o 15 stopni.
        angle += 15.0; 
 
        rotate.setAngle(angle);        
        rotate.setPivotX(btnRotate.getWidth()/2); 
        rotate.setPivotY(btnRotate.getHeight()/2); 
      }  
    });  
  
    // Obsuga zdarze przycisku "Skalowanie".
    btnScale.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Kade kliknicie przycisku powoduje powikszenie 
        // wspczynnika przeskalowania.
        scaleFactor += 0.1; 
        if(scaleFactor > 2.0) scaleFactor = 0.4; 
 
        scale.setX(scaleFactor); 
        scale.setY(scaleFactor);         
 
      }  
    });  
 
    // Obsuga zdarze przycisku "Zamazanie".
    btnBlur.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        // Kade kliknicie przycisku powoduje zmian stopnia zamazania.
        if(blurVal == 10.0) { 
          blurVal = 1.0; 
          btnBlur.setEffect(null); 
          btnBlur.setText("Zamazanie wyczone"); 
        } else { 
          blurVal++; 
          btnBlur.setEffect(blur);  
          btnBlur.setText("Zamazanie wczone"); 
        } 
        blur.setWidth(blurVal); 
        blur.setHeight(blurVal); 
      }  
    });  
 
    // Dodaje etykiet i kontrolk listy do grafu sceny.
    rootNode.getChildren().addAll(btnRotate, btnScale, btnBlur, reflect);  
 
    // Wywietla scen i obszar roboczy. 
    myStage.show();  
  }  
}
