// Program przedstawia tworzenie i stosowanie referencji 
// metod statycznych.
 
// Interfejs funkcyjnych przeznaczony dla predykatw liczbowych
// operujcych na wartociach cakowitych.
interface IntPredicate { 
  boolean test(int n); 
} 
 
// Ta klasa definiuje trzy metody statyczne, ktre sprawdzaj 
// okrelone warunki zwizane z liczbami cakowitymi. 
class MyIntPredicates { 
  // Metoda statyczna zwracajca warto true, jeli przekazana 
  // warto jest liczb pierwsz.
  static boolean isPrime(int n) { 
 
    if(n < 2) return false; 
 
    for(int i=2; i <= n/i; i++) { 
      if((n % i) == 0)  
        return false; 
    } 
    return true; 
  } 
 
  // Metoda statyczna zwracajca warto true, jeli przekazana 
  // warto jest parzysta.
  static boolean isEven(int n) { 
    return (n % 2) == 0; 
  } 
 
  // Metoda statyczna zwracajca true, jeli przekazana warto
  // jest wiksza od zera.
  static boolean isPositive(int n) { 
    return n > 0; 
  } 
}     
 
class MethodRefDemo { 
 
  // W tej metodzie typem pierwszego parametru jest interfejs
  // funkcyjny. Oznacza to, e mona do niej przekaza referencj
  // dowolnej instancji tego interfejsu, w tym take instancji 
  // utworzonej przez referencj metody.
  static boolean numTest(IntPredicate p, int v) { 
    return p.test(v); 
  } 
 
  public static void main(String args[]) 
  { 
    boolean result; 
     
    // W wywoaniu metody numTest() przekazywana jest referencja
    // metody isPrime().
    result = numTest(MyIntPredicates::isPrime, 17); 
    if(result) System.out.println("17 jest liczb pierwsz."); 
 
    // Tu przekazywana jest referencja metody isEven(). 
    result = numTest(MyIntPredicates::isEven, 12); 
    if(result) System.out.println("12 jest liczb parzyst.");  
 
    // I w kocu przekazywana jest referencja metody isPositive. 
    result = numTest(MyIntPredicates::isPositive, 11); 
    if(result) System.out.println("11 jest liczb wiksz od 0."); 
  } 
}
