// Przykad zastosowania tego samego interfejsu funkcyjnego z trzema
// rnymi wyraeniami lambda.

// Interfejs funkcyjny, ktrego metoda ma dwa parametry typu int 
// i zwraca wynik typu boolean.
interface NumericTest {
  boolean test(int n, int m);
}

class LambdaDemo2 {
  public static void main(String args[])
  {
    // To wyraenie lambda sprawdza, czy jedna liczba 
    // jest czynnikiem drugiej.
    NumericTest isFactor = (n, d) -> (n % d) == 0;
    if(isFactor.test(10, 2))
      System.out.println("2 jest czynnikiem liczby 10");
    if(!isFactor.test(10, 3))
      System.out.println("3 nie jest czynnikiem liczby 10");
    System.out.println();

    // To wyraenie lambda zwraca true, jeli pierwszy 
    // argument jest mniejszy od drugiego.
    NumericTest lessThan = (n, m) -> (n < m);
    if(lessThan.test(2, 10))
      System.out.println("2 jest mniejsze od 10");
    if(!lessThan.test(10, 2))
      System.out.println("10 nie jest mniejsze od 2");
    System.out.println();

    // To wyraenie lambda zwraca true, jeli wartoci bezwzgldne
    // argumentw s sobie rwne.
    NumericTest absEqual = (n, m) -> (n < 0 ? -n : n) == (m < 0 ? -m : m);
    if(absEqual.test(4, -4))
      System.out.println("Wartoci bezwzgldne 4 i -4 s rwne.");
    if(!lessThan.test(4, -5))
      System.out.println("Wartoci bezwzgldne 4 i -5 nie s rwne.");
    System.out.println()
  }
}