// Prezentacja referencji konstruktorw.
 
// MyFunc jest interfejsem funkcyjnym, ktrego metoda zwraca 
// referencj MyClass. 
interface MyFunc { 
   MyClass func(String s); 
} 
 
class MyClass { 
  private String str; 
 
  // Konstruktor ma jeden parametr. 
  MyClass(String s) { str = s; } 
 
  // A to jest konstruktor domylny. 
  MyClass() { str = ""; } 
 
  // ... 
 
  String getStr() { return str; }   
}     
 
class ConstructorRefDemo { 
  public static void main(String args[]) 
  { 
    // Tworzy referencj konstruktora klasy MyClass.
    // Poniewa metoda func() interfejsu MyFunc wymaga przekazania
    // jednego argumentu, zatem new odwouje si do konstruktora
    // klasy MyClass, ktry ma parametr, a nie do konstruktora
    // domylnego.
    MyFunc myClassCons = MyClass::new; 
 
    // Tworzy instancj klasy MyClass przy uyciu referencji
    // konstruktora.
    MyClass mc = myClassCons.func("Testujemy"); 
 
    // Uywa utworzonej przed chwil instancji klasy MyClass.
    System.out.println("acuchem w zmiennej mc jest: " + mc.getStr( )); 
  } 
}
