// Przedstawienie dwch prostych wyrae lambda.

// Interfejs funkcyjny.
interface MyValue {
  double getValue();
}

// Drugi interfejs funkcyjny.
interface MyParamValue {
  double getValue(double v);
}

class LambdaDemo {
  public static void main(String args[])
  {
    MyValue myVal; // Deklaruje referencj typu interfejsu.
    // W tym przykadzie wyraenie lambda zwraca warto sta.
    // Po przypisaniu wyraenia do zmiennej zostaje utworzona 
    // instancja klasy, w ktrej wyraenie lambda implementuje 
    // metod getValue() interfejsu MyValue.
    myVal = () -> 98.6;

    // Wywouje metod getValue(), ktra jest okrelana przez
    // przypisane wczeniej wyraenie lambda.
    System.out.println("Warto staa: " + myVal.getValue());

    // Tworzy wyraenie lambda z parametrem i przypisuje
    // je zmiennej typu MyParamValue. To wyraenie zwraca warto
    // odwrotn przekazanego argumentu.
    MyParamValue myPval = (n) -> 1.0 / n;

    // Wywouje getValue(v), uywajc referencji myPval.
    System.out.println("Odwrotnoci liczby 4 jest " + myPval.getValue(4.0));
    System.out.println("Odwrotnoci liczby 8 jest " + myPval.getValue(8.0));
    // Wyraenie lambda musi by zgodne z metod zdefiniowan 
    // w interfejsie funkcyjnym. Dlatego prba zastosowania poniszych
    // wyrae skoczy si zgoszeniem bdu:
    // myVal = () -> "trzy"; // Bd! Typ String nie jest zgodny z double!
    // myPval = () -> Math.random(); // Bd! Wymagany parametr!
  }
}
