// Zastosowanie wyraenia lambda jako argumentu metody. 
 
interface StringFunc { 
  String func(String str); 
} 
 
class LambdaArgumentDemo { 
 
  // W tej metodzie typem pierwszego parametru jest interfejs 
  // funkcyjny. Oznacza to, e mona do niej przekaza dowoln 
  // referencj instancji tego typu, w tym take instancji 
  // utworzonej przy uyciu wyraenia lambda. Drugi parametr 
  // okrela acuch znakowy, na ktrym naley operowa.
  static String changeStr(StringFunc sf, String s) { 
    return sf.func(s); 
  } 
 
  public static void main(String args[]) 
  { 
    String inStr = "Wyraenia lambda rozszerzaj moliwoci Javy"; 
    String outStr; 
 
    System.out.println("acuch wejciowy: " + inStr); 
 
    // Definiuje wyraenie lambda, ktre odwraca kolejno 
    // znakw w acuchu i zapisuje je w zmiennej referencyjnej
    // typu StringFunc. 
    StringFunc reverse = (str) ->  { 
      String result = ""; 
 
      for(int i = str.length()-1; i >= 0; i--) 
        result += str.charAt(i); 
 
      return result; 
    }; 
 
    // Przekazuje warto zmiennej reverse jako pierwszy argument
    // wywoania metody changeStr(). 
    // Drugim argumentem jest wejciowy acuch znakowy. 
    outStr = changeStr(reverse, inStr); 
    System.out.println("Odwrcony acuch znakowy: " + outStr); 
 
    // To wyraenie lambda zamienia znaki odstpu na minusy.
    // Podano je bezporednio w wywoaniu metody changeStr().
    outStr = changeStr((str) -> str.replace(' ', '-'), inStr); 
    System.out.println("acuch z zamienionymi odstpami: " + outStr); 
 
    // To blokowe wyraenie lambda zmienia mae litery na wielkie 
    // i wielkie na mae. Take ono zostao podane bezporednio 
    // w wywoaniu metody changeStr().
    outStr = changeStr((str) -> { 
                         String result = ""; 
                         char ch; 
 
                         for(int i = 0; i < str.length(); i++ ) { 
                           ch = str.charAt(i); 
                           if(Character.isUpperCase(ch)) 
                             result += Character.toLowerCase(ch); 
                           else  
                             result += Character.toUpperCase(ch); 
                         } 
                         return result; 
                       }, inStr); 
 
    System.out.println("acuch ze zmienion wielkoci liter: " + outStr); 
  } 
}
