// Uywa argumentu wieloznacznego. 
class NumericFns<T extends Number> {  
  T num; 
    
  // Przekazuje konstruktorowi referencj
  // obiektu numerycznego. 
  NumericFns(T n) {  
    num = n; 
  }  
  
  // Zwraca odwrotno. 
  double reciprocal() { 
    return 1 / num.doubleValue(); 
  } 
 
  // Zwraca cz uamkow. 
  double fraction() { 
    return num.doubleValue() - num.intValue(); 
  } 
 
  // Sprawdza czy wartoci bezwzgldne dwch obiektw s takie same.
  boolean absEqual(NumericFns<?> ob) { 
    if(Math.abs(num.doubleValue()) == 
         Math.abs(ob.num.doubleValue())) return true; 
 
    return false; 
  } 
 
  // ... 
}  
  
// Demonstruje uycie argumentu wieloznacznego. 
class WildcardDemo {  
  public static void main(String args[]) {  
 
    NumericFns<Integer> iOb = 
                      new NumericFns<Integer>(6);   
 
    NumericFns<Double> dOb = 
                      new NumericFns<Double>(-6.0); 
 
    NumericFns<Long> lOb =  
                      new NumericFns<Long>(5L); 
  
    System.out.println("Sprawdzam iOb i dOb."); 
    if(iOb.absEqual(dOb)) 
      System.out.println("Wartoci bezwzgldne s takie same."); 
    else 
      System.out.println("Wartoci bezwzgldne rni si."); 
 
    System.out.println(); 
 
    System.out.println("Sprawdzam iOb i lOb."); 
    if(iOb.absEqual(lOb)) 
      System.out.println("Wartoci bezwzgldne s takie same."); 
    else 
      System.out.println("Wartoci bezwzgldne rni si."); 
  
  }  
}
