/*
   Przykad 10.2

   System pomocy wykorzystujcy plik
   do przechowywania tematw pomocy.

   Wymaga JDK 7 lub nowszej wersji.
*/

import java.io.*;

/* Klasa Help otwiera plik pomocy,
   wyszukuje temat, a nastpnie wywietla
   informacje zwizane z tym tematem.
   Zwr uwag, e sama obsuguje 
   wszystkie wyjtki wejcia/wyjcia. */
class Help {
  String helpfile; // nazwa pliku pomocy

  Help(String fname) {
    helpfile = fname;
  }

  // Wywietla informacje z pliku pomocy na podany temat.
  boolean helpOn(String what) {
    int ch;
    String topic, info;

    // Otwiera plik pomocy.
    try (BufferedReader helpRdr =
            new BufferedReader(new FileReader(helpfile)))
    {
      do {
        // wczytuje znaki do momentu odnalezienia znaku #
        ch = helpRdr.read();

        // sprawdza czy temat si zgadza
        if(ch == '#') {
          topic = helpRdr.readLine();
          if(what.compareTo(topic) == 0) { // temat znaleziony
            do {
              info = helpRdr.readLine();
              if(info != null) System.out.println(info);
            } while((info != null) &&
                    (info.compareTo("") != 0));
            return true;
          }
        }
      } while(ch != -1);
    }
    catch(IOException exc) {
      System.out.println("Bd podczas dostpu do pliku pomocy.");
      return false;
    }
    return false; // temat nie zosta znaleziony
  }

  // Pobiera temat pomocy.
  String getSelection() {
    String topic = "";

    BufferedReader br = new BufferedReader(
              new InputStreamReader(System.in));

    System.out.print("Podaj temat: ");
    try {
      topic = br.readLine();
    }
    catch(IOException exc) {
      System.out.println("Bd podczas odczytu z konsoli.");
    }
    return topic;
  }
}

// Demonstruje dziaanie systemu pomocy uywajcego plik pomocy.
class FileHelp {
  public static void main(String args[]) {
    Help hlpobj = new Help("helpfile.txt");
    String topic;

    System.out.println("Wyprbuj system pomocy. " +
                       "Wprowad 'stop' aby zakoczy.");
    do {
      topic = hlpobj.getSelection();

      if(!hlpobj.helpOn(topic))
        System.out.println("Temat nie zosta znaleziony.\n");

    } while(topic.compareTo("stop") != 0);
  }
}
