/* Kopiuje plik tekstowy.
   Uruchamiajc ten program, podaj nazw pliku
   rdowego i pliku docelowego.
   Na przykad, aby skopiowa plik FIRST.TXT
   do pliku SECOND.TXT, uyj poniszego
   wywoania.

   java -Dfile.encoding=CP852 CopyFile FIRST.TXT SECOND.TXT
*/

import java.io.*;

class CopyFile {
  public static void main(String args[]) throws IOException 
  {
    int i;
    FileInputStream fin = null;
    FileOutputStream fout = null;

    // Upewnia si, e podano nazwy obu plikw.
    if(args.length != 2) {
      System.out.println("Sposb uycia: CopyFile rdo Cel");
      return;
    }

    // Kopiuje plik.
    try {
      // Prbuje otworzy pliki.
      fin = new FileInputStream(args[0]);
      fout = new FileOutputStream(args[1]);

      do {
        i = fin.read();
        if(i != -1) fout.write(i);
      } while(i != -1);

    } catch(IOException exc) {
      System.out.println("Bd wejcia/wyjcia: " + exc);
    } finally {
      try {
        if(fin != null) fin.close();
      } catch(IOException exc) {
        System.out.println("Bd podczas zamykania pliku rdowego.");
      }
      try {
        if(fout != null) fout.close();
      } catch(IOException exc) {
        System.out.println("Bd podczas zamykania pliku docelowego.");
      }
    }
  }
}
