/*
   Przykad 10.1.

   Porwnuje dwa pliki.

   Uruchamiajc ten program podaj w wierszu polece
   nazwy porwnywanych plikw.

   java -Dfile.encoding=CP852 CompFile FIRST.TXT SECOND.TXT

   Wymaga JDK 7 lub nowszej wersji.
*/

import java.io.*;

class CompFiles {
  public static void main(String args[])
  {
    int i=0, j=0;

    // Upewnia si, e podano nazwy obu plikw.
    if(args.length !=2 ) {
      System.out.println("Sposb uycia: CompFiles plik1 plik2");
      return;
    }

    // Porwnuje pliki.
    try (FileInputStream f1 = new FileInputStream(args[0]);
         FileInputStream f2 = new FileInputStream(args[1]))
    {
      // Sprawdza zawarto kadego pliku.
      do {
        i = f1.read();
        j = f2.read();
        if(i != j) break;
      } while(i != -1 && j != -1);

      if(i != j)
        System.out.println("Pliki rni si.");
      else
        System.out.println("Pliki s takie same.");
    } catch(IOException exc) {
      System.out.println("Bd wejcia/wyjcia: " + exc);
    }
  }
}
