// Program demonstrujcy stosowanie pl wyboru. 
 
import javafx.application.*; 
import javafx.scene.*; 
import javafx.stage.*; 
import javafx.scene.layout.*; 
import javafx.scene.control.*; 
import javafx.event.*; 
import javafx.geometry.*; 
 
public class CheckboxDemo extends Application { 
 
  CheckBox cbSmartphone; 
  CheckBox cbTablet; 
  CheckBox cbNotebook; 
  CheckBox cbDesktop; 
 
  Label response; 
  Label selected; 
 
  String computers; 
 
  public static void main(String[] args) { 
 
    // Uruchamia aplikacj JavaFX, wywoujc metod launch(). 
    launch(args);   
  } 
 
  // Przesonicie metody start(). 
  public void start(Stage myStage) { 
 
    // Okrela tytu obszaru roboczego. 
    myStage.setTitle("Prezentacja pl wyboru"); 
 
    // Jako korze zostaje uyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstpy pomidzy umieszczonymi
    // w nim kontrolkami bd wynosi 10. 
    FlowPane rootNode = new FlowPane(Orientation.VERTICAL, 10, 10); 
 
    // Wyrwnuje kontrolki do rodka.
    rootNode.setAlignment(Pos.CENTER); 
 
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 230, 200); 
 
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene); 
 
    Label heading = new Label("Jakie komputery posiadasz?"); 
 
    // Tworzy etykiet, ktra bdzie nas informowa o zmianie
    // stanu pola wyboru.
    response = new Label(""); 
 
    // Tworzy etykiet, ktra bdzie nas informowa o tym,
    // ktre pola s zaznaczone.
    selected = new Label(""); 
 
    // Tworzy cztery pola wyboru. 
    cbSmartphone = new CheckBox("Smartfon"); 
    cbTablet = new CheckBox("Tablet"); 
    cbNotebook = new CheckBox("Notebook"); 
    cbDesktop = new CheckBox("Stacjonarny"); 
 
    // Obsuga zdarze ActionEvent pl wyboru. 
    cbSmartphone.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(cbSmartphone.isSelected()) 
          response.setText("Zaznaczono pole 'smartfon'."); 
        else 
          response.setText("Usunito zaznaczenie pola 'smartfon'."); 
 
        showAll(); 
      } 
    }); 
 
    cbTablet.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(cbTablet.isSelected()) 
          response.setText("Zaznaczono pole 'tablet'."); 
        else 
          response.setText("Usunito zaznaczenie pola 'tablet'."); 
 
        showAll(); 
      } 
    }); 
 
    cbNotebook.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(cbNotebook.isSelected()) 
          response.setText("Zaznaczono pole 'notebook'."); 
        else 
          response.setText("Usunito zaznaczenie pola 'notebook'."); 
 
        showAll(); 
      } 
    }); 
 
    cbDesktop.setOnAction(new EventHandler<ActionEvent>() { 
      public void handle(ActionEvent ae) { 
        if(cbDesktop.isSelected()) 
          response.setText("Zaznaczono pole 'stacjonarny'."); 
        else 
          response.setText("Usunito zaznaczenie pola 'stacjonarny'."); 
 
        showAll(); 
      } 
    }); 
 
    // Dodaje kontrolki do grafu sceny.
    rootNode.getChildren().addAll(heading, cbSmartphone, cbTablet, 
                                  cbNotebook, cbDesktop, response, selected); 
 
    // Wywietla scen i obszar roboczy. 
    myStage.show(); 
 
    showAll(); 
  } 
 
  // Aktualizuje zawarto okna aplikacji. 
  void showAll() { 
    computers = ""; 
    if(cbSmartphone.isSelected()) computers = "smartfon "; 
    if(cbTablet.isSelected()) computers += "tablet "; 
    if(cbNotebook.isSelected()) computers += "notebook "; 
    if(cbDesktop.isSelected()) computers += "stacjonarny"; 
 
    selected.setText("Zaznaczone komputery: " + computers); 
  } 
}
