// Zastosowanie sparametryzowanego interfejsu funkcyjnego. 
 
// Sprametryzowany interfejs funkcyjny, ktrego metoda ma 
// dwa parametry i zwraca warto typu boolean.
interface SomeTest<T> { 
  boolean test(T n, T m); 
} 
 
class GenericFunctionalInterfaceDemo { 
  public static void main(String args[]) 
  { 
    // To wyraenie lambda sprawdza, czy jedna liczba cakowita 
    // jest czynnikiem drugiej.
    SomeTest<Integer> isFactor = (n, d) -> (n % d) == 0; 
 
    if(isFactor.test(10, 2)) 
      System.out.println("Liczba 2 jest czynnikiem liczby 10"); 
    System.out.println(); 
 
    // Kolejne wyraenie lambda sprawdza, czy jedna liczba 
    // typu Double jest czynnikiem drugiej. 
    SomeTest<Double> isFactorD = (n, d) -> (n % d) == 0; 
 
    if(isFactorD.test(212.0, 4.0)) 
      System.out.println("Liczba 4.0 jest czynnikiem liczby 212.0"); 
    System.out.println(); 
 
    // To wyraenie lambda sprawdza czy, jeden acuch znakowy jest
    // fragmentem drugiego.
    SomeTest<String> isIn = (a, b) -> a.indexOf(b) != -1; 
 
    String str = "Sprametryzowany interfejs funkcyjny"; 
 
    System.out.println("Sprawdzamy acuch znakowy: " + str); 
 
    if(isIn.test(str, "fejs")) 
      System.out.println("acuch 'fejs' zosta znaleziony."); 
    else 
      System.out.println("acuch 'fejs' nie zosta znaleziony."); 
  } 
}
