// Wersja programu do porwnywania plikw z przykadu 16.1,
// napisana z uyciem JavaFX.
  
import javafx.application.*;  
import javafx.scene.*;  
import javafx.stage.*;  
import javafx.scene.layout.*;  
import javafx.scene.control.*;  
import javafx.event.*;  
import javafx.geometry.*;  
import java.io.*; 
  
public class JavaFXFileComp extends Application {  
  
  TextField tfFirst;  // przechowuje nazw pierwszego pliku
  TextField tfSecond; // przechowuje nazw drugiego pliku
 
  Button btnComp; // przycisk porwnania plikw
 
  Label labFirst, labSecond; // wywietlaj zachty
  Label labResult; // wywietla wynik i komunikaty o bdach
 
  public static void main(String[] args) {  
  
    // Uruchamia aplikacj JavaFX, wywoujc metod launch(). 
    launch(args);    
  }  
  
  // Przesonicie metody start(). 
  public void start(Stage myStage) {  
  
    // Okrela tytu obszaru roboczego. 
    myStage.setTitle("Porwnywanie plikw");  
  
    // Jako korze zostaje uyty panel FlowPane. W tym 
    // przypadku pionowe i poziome odstpy pomidzy umieszczonymi
    // w nim kontrolkami bd wynosi 10. 
    FlowPane rootNode = new FlowPane(10, 10);  
  
    // Wyrwnuje kontrolki do rodka.
    rootNode.setAlignment(Pos.CENTER);  
  
    // Tworzy obiekt Scene. 
    Scene myScene = new Scene(rootNode, 180, 180);  
  
    // Dodaje obiekt Scene do obiektu Stage. 
    myStage.setScene(myScene);  
  
    // Tworzy pola tekstowe do podania nazw plikw. 
    tfFirst = new TextField(); 
    tfSecond = new TextField(); 
 
    // Ustawia preferowan liczb kolumn w polach. 
    tfFirst.setPrefColumnCount(12); 
    tfSecond.setPrefColumnCount(12); 
 
    // Ustawia etykiety pl tekstowych. 
    tfFirst.setPromptText("Enter file name.");  
    tfSecond.setPromptText("Enter file name.");  
 
    // Tworzy przycisk Porwnaj. 
    btnComp = new Button("Porwnaj"); 
 
    // Tworzy etykiety.
    labFirst = new Label("Pierwszy plik: "); 
    labSecond = new Label("Drugi plik: "); 
    labResult = new Label(""); 
 
    // Stosuje wyraenia lambda do obsugi zdarze ActionEvent
    // pl tekstowych. W obu przypadkach symulowane jest kliknicie
    // przycisku Porwnaj.
    tfFirst.setOnAction( (ae) -> btnComp.fire());  
    tfSecond.setOnAction( (ae) -> btnComp.fire());  
 
    // Obsuga zdarze ActionEvent przycisku Porwnaj. 
    btnComp.setOnAction(new EventHandler<ActionEvent>() {  
      public void handle(ActionEvent ae) {  
        int i=0, j=0; 
 
        // Najpierw upewniamy si, e w obu polach zostay 
        // wpisane nazwy plikw.
        if(tfFirst.getText().equals("")) { 
          labResult.setText("Brak nazwy pierwszego pliku."); 
          return; 
        } 
        if(tfSecond.getText().equals("")) { 
          labResult.setText("Brak nazwy drugiego pliku."); 
          return; 
        } 
 
        // Porwnuje pliki. Uywa rozszerzonej instrukcji try do zarzdzania plikami.
        try (FileInputStream f1 = new FileInputStream(tfFirst.getText()); 
             FileInputStream f2 = new FileInputStream(tfSecond.getText())) 
        { 
          // Porwnuje zawarto plikw.
          do { 
            i = f1.read(); 
            j = f2.read(); 
            if(i != j) break; 
          } while(i != -1 && j != -1); 
 
          if(i != j) 
            labResult.setText("Pliki s rne."); 
          else 
            labResult.setText("Pliki s takie same."); 
 
        } catch(IOException exc) { 
          labResult.setText("Bd dostpu do pliku."); 
        } 
      } 
    });  
  
    // Dodaje etykiet i przyciski do grafu sceny.
    rootNode.getChildren().addAll(labFirst, tfFirst, labSecond, tfSecond, 
                                  btnComp, labResult);  
  
    // Wywietla scen i obszar roboczy.
    myStage.show();  
  }  
}

