// Prosty aplet wykorzystujcy Swing

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/*
Kod HTML wykorzystywany podczas uruchamiania apletu:

<applet code="MySwingApplet" width=200 height=80>
</applet>
*/

public class MySwingApplet extends JApplet {
  JButton jbtnUp;
  JButton jbtnDown;

  JLabel jlab;

  // Inicjalizacja apletu.
  public void init() {
    try {
      SwingUtilities.invokeAndWait(new Runnable () {
        public void run() {
          makeGUI(); // inicjalizacja interfejsu uytkownika
        }
      });
    } catch(Exception exc) {
      System.out.println("Nie mona uruchomi apletu: "+ exc);
    }
  }

  // Ten aplet nie potrzebuje przesania metod start(), stop()
  // i destroy(). 

  // Konfiguruje i inicjalizuje interfejs uytkownika. 
  private void makeGUI() {
    // Wybiera menedera ukadu komponentw.
    setLayout(new FlowLayout());

    // Tworzy dwa przyciski.
    jbtnUp = new JButton("Gra");
    jbtnDown = new JButton("D");

    // Dodaje suchacza zdarze przycisku Gra.
    jbtnUp.addActionListener(new ActionListener() {     
      public void actionPerformed(ActionEvent ae) { 
        jlab.setText("Nacisne przycisk Gra."); 
      }
    });

    // Dodaje suchacza zdarze przycisku D.
    jbtnDown.addActionListener(new ActionListener() {     
      public void actionPerformed(ActionEvent ae) { 
        jlab.setText("Nacisne przycisk D."); 
      }     
    });     

    // Umieszcza przyciski w panelu zawartoci.
    add(jbtnUp);
    add(jbtnDown);

    // Tworzy etykiet.
    jlab = new JLabel("Nacinij przycisk.");

    // Umieszcza etykiet w panelu zawartoci.
    add(jlab);    
  }
}
