// W tej wersji klasyNumericFns, typ przekazywany 
// jako parametr T musi by albo klas Number 
// albo jej klas pochodn. 
class NumericFns<T extends Number> {  
  T num; 
    
  // Przekazuje konstruktorowi referencj
  // obiektu numerycznego.
  NumericFns(T n) {  
    num = n; 
  }  
  
  // Zwraca odwrotno. 
  double reciprocal() { 
    return 1 / num.doubleValue(); 
  } 
 
  // Zwraca cz uamkow. 
  double fraction() { 
    return num.doubleValue() - num.intValue(); 
  } 
 
  // ... 
}  
  
// Demonstruje uycie klasy NumericFns.  
class BoundsDemo {  
  public static void main(String args[]) {  
 
    NumericFns<Integer> iOb = 
                      new NumericFns<Integer>(5);   
 
    System.out.println("Odwrotno iOb wynosi " + 
                        iOb.reciprocal()); 
    System.out.println("Cz dziesitna iOb wynosi " + 
                        iOb.fraction()); 
 
    System.out.println(); 
 
    NumericFns<Double> dOb = 
                      new NumericFns<Double>(5.25);   
 
    System.out.println("Odwrotno dOb wynosi " + 
                        dOb.reciprocal()); 
    System.out.println("Cz dziesitna dOb wynosi " + 
                        dOb.fraction()); 
 
 
    // Ta instrukcja nie zostanie skompilowana, poniewa String
    // nie jest klas pochodn klasy Number. 
//    NumericFns<String> strOb = new NumericFns<String>("Bd");   
  }  
}
