// Przykad 12.1

// Sumulacja sygnalizacji wietlnej 
// wykorzystujca wyliczenie kolorw wiata. 
 
// Wyliczenie stanw sygnalizatora. 
enum TrafficLightColor {  
  CZERWONE, ZIELONE, ZOLTE 
} 
 
// Skomputeryzowana sygnalizacja wietlna. 
class TrafficLightSimulator implements Runnable { 
  private Thread thrd; // referencja wtku wykonywujcego symulacj 
  private TrafficLightColor tlc; // przechowuje biecy kolor wiata
  boolean stop = false; // warto true zatrzymuje symulacj
  boolean changed = false; // ma warto true gdy wiato zmienio si
 
  TrafficLightSimulator(TrafficLightColor init) {  
    tlc = init; 
 
    thrd = new Thread(this); 
    thrd.start(); 
  } 
 
  TrafficLightSimulator() {  
    tlc = TrafficLightColor.CZERWONE; 
 
    thrd = new Thread(this); 
    thrd.start(); 
  } 
 
  // Rozpoczyna symulacj. 
  public void run() { 
    while(!stop) { 
      try { 
        switch(tlc) { 
          case ZIELONE: 
            Thread.sleep(10000); // zielone przez 10 sekund 
            break; 
          case ZOLTE: 
            Thread.sleep(2000);  // zte przez 2 sekundy
            break; 
          case CZERWONE: 
            Thread.sleep(12000); // czerwone przez 12 sekund
            break; 
        } 
      } catch(InterruptedException exc) { 
        System.out.println(exc); 
      } 
      changeColor(); 
    }  
  } 
 
  // Zmienia kolor. 
  synchronized void changeColor() { 
    switch(tlc) { 
      case CZERWONE: 
        tlc = TrafficLightColor.ZIELONE; 
        break; 
      case ZOLTE: 
        tlc = TrafficLightColor.CZERWONE; 
        break; 
      case ZIELONE: 
       tlc = TrafficLightColor.ZOLTE; 
    } 
 
    changed = true;
    notify(); // sygnalizuje, e wiatlo zmienio si
  } 
 
  // Czeka na zmian wiata. 
  synchronized void waitForChange() { 
    try { 
      while(!changed) 
        wait(); // Czeka na zmian wiata.
      changed = false;
    } catch(InterruptedException exc) { 
      System.out.println(exc); 
    } 
  } 
 
  // Zwraca biecy kolor wiata. 
  synchronized TrafficLightColor getColor() { 
    return tlc; 
  } 
 
  // Zatrzymuje sygnalizacj. 
  synchronized void cancel() { 
    stop = true; 
  } 
}  
  
class TrafficLightDemo {  
  public static void main(String args[]) {  
    TrafficLightSimulator tl =
      new TrafficLightSimulator(TrafficLightColor.ZIELONE); 
 
    for(int i=0; i < 9; i++) { 
      System.out.println(tl.getColor()); 
      tl.waitForChange(); 
    } 
 
    tl.cancel(); 
  }  
}
