// Demonstruje plik o swobodnym dostpie.

// Wymaga JDK 7 lub nowszej wersji.

import java.io.*;

class RandomAccessDemo {
  public static void main(String args[])
  {
    double data[] = { 19.4, 10.1, 123.54, 33.0, 87.9, 74.25 };
    double d;

    // Otwiera i uywa plik o swobodnym dostpie.
    try (RandomAccessFile raf = new RandomAccessFile("random.dat", "rw"))
    {
      // Zapisuje w pliku wartoci z tablicy data.
      for(int i=0; i < data.length; i++) {
        raf.writeDouble(data[i]);
      }

      // Teraz odczytuje poszczeglne wartoci.
      raf.seek(0); // odczytuje pierwsz warto
      d = raf.readDouble();
      System.out.println("Pierwsza warto: " + d);

      raf.seek(8); // odczytuje drug warto
      d = raf.readDouble();
      System.out.println("Druga warto: " + d);

      raf.seek(8 * 3); // odczytuje czwart warto
      d = raf.readDouble();
      System.out.println("Czwarta warto: " + d);

      System.out.println();

      // Teraz odczytuje co drug warto.
      System.out.println("Co druga warto: ");
      for(int i=0; i < data.length; i+=2) {
        raf.seek(8 * i); // przesuwa wskanik do i-tej wartoci double
        d = raf.readDouble();
        System.out.print(d + " ");
      }
    }
    catch(IOException exc) {
      System.out.println("Bd wejcia/wyjcia: " + exc);
    }
  }
}
