/* Kopiuje plik tekstowy, zastpujc odstpy mylnikami. 
  
   Ta wersja uywa strumieni bajtowych. 
 
   Aby uy tego programu, podaj nazw pliku rdowego   
   oraz nazw pliku docelowego.  
   Na przykad: 
  
   java -Dfile.encoding=CP852 Hyphen zrodlo cel 
*/  
 
import java.io.*; 
 
class Hyphen { 
  public static void main(String args[])  
  { 
    int i; 
    FileInputStream fin = null; 
    FileOutputStream fout = null; 

    // Sprawdza, czy podano nazwy obu plikw.
    if(args.length !=2 ) {
      System.out.println("Sposb uycia: Hyphen zrodlo cel"); 
      return;
    }
 
    // Kopiuje zawarto pliku zastpujc odstpy mylnikami.
    try { 
      fin = new FileInputStream(args[0]); 
      fout = new FileOutputStream(args[1]); 

      do { 
        i = fin.read(); 

        // zamienia odstp na mylnik
        if((char)i == ' ') i = '-'; 

        if(i != -1) fout.write(i); 
      } while(i != -1); 
    } catch(IOException exc) { 
      System.out.println("Bd wejcia/wyjcia: " + exc); 
    } finally {
      try {
        if(fin != null) fin.close(); 
      } catch(IOException exc) { 
        System.out.println("Bd podczas zamykania pliku rdowego."); 
      } 

      try {
        if(fin != null) fout.close(); 
      } catch(IOException exc) { 
        System.out.println("Bd podczas zamykania pliku docelowego."); 
      } 
    }
  } 
}
