package javanut8.ch12;

import java.lang.management.ManagementFactory;

/**
 * Java 8 GetPID class
 * 
 * @author ben
 */
public class GetPID {
    public static long getPid() {
        // To dość niezdarne wywołanie używa JMX w celu zwrócenia nazwy, która
        // reprezentuje obecnie działającą JVM. Ta nazwa ma format
        // <pid>@<nazwahosta> tylko w maszynach wirtualnych OpenJDK i Oracle.
        // Nie ma gwarantowanego przenośnego rozwiązania w Javie 8.
        final String jvmName = 
            ManagementFactory.getRuntimeMXBean().getName();
        final int index = jvmName.indexOf('@');
        if (index < 1)
            return -1;

        try {
            return Long.parseLong(jvmName.substring(0, index));
        } catch (NumberFormatException nfe) {
            return -1;
        }
    }
}
