package javanut8.ch06;

public class ScratchThreads {

	private static ScratchThreads instance = null;

	// Konstruktor
	public ScratchThreads() {
		super();
	}

	/*
	 * Miejsce na twój kod
	 */
	private void run() {
        Thread t = new Thread(() -> {System.out.println("Hello Thread");});
        t.start();
	}


    public void run2() {
        // Ten wątek tylko zgłasza wyjątek.
Thread handledThread =
  new Thread(() -> { throw new UnsupportedOperationException(); });

  // Nadanie wątkowi nazwy ułatwia późniejszą diagnostykę.
  handledThread.setName("Mój zepsuty wątek" );

// procedura obsługi tego błędu
handledThread.setUncaughtExceptionHandler((t, e) -> {
    System.err.printf("Wystąpił wyjątek w wątku %d „%s”:" +
        "%s w wierszu %d z %s%n" ,
        t.getId(),    // identyfikator wątku
        t.getName(),  // nazwa wątku
        e.toString(), // nazwa wyjątku i wiadomość o błędzie
        e.getStackTrace()[0].getLineNumber(),
        e.getStackTrace()[0].getFileName()); });
handledThread.start();


    }

    public Thread run3() {
        // Ten wątek tylko zgłasza wyjątek
        Thread handledThread = new Thread(() -> { throw new UnsupportedOperationException(); });
        handledThread.start();
        return handledThread;
    }
    
    public void run4() {
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

        /**
         * @param args
         * @throws java.io.IOException
         */
    public static void main(String[] args) throws Exception {
		instance = new ScratchThreads();
		instance.run();
        Thread ret = instance.run3();
        instance.run2();
        instance.run4();
        ret.join();
        Thread.sleep(1000);
        System.out.println("program kończy normalnie");
	}

}
