package javanut8.ch04;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

// Parę dodatkowych przykładów objaśniających parę ogólnych spraw, o które
// pytali mnie czytelnicy — szersza dyskusja na ten temat można znaleźć się w wydaniu 7.
public class GenericsExamples {

    private static GenericsExamples instance = null;

    // Konstruktor
    public GenericsExamples() {
        super();
    }

    /*
     * To jest prosty przykład objaśniający różnicę między wariancją 
     * typów w przypadku list (i innych typów generycznych) i tablic
     */
    private void run() {
        // Nie przejdzie kompilacji
//        List<Object> objects = new ArrayList<String>();
        // Ten wiersz jest w porządku
        List<?> unknownObjects = new ArrayList<String>();

        // Nie możemy dodać wszystkiego do listy nieznanego typu 
        // Następny wiersz spowoduje błąd kompilacji
//        unknownObjects.add(new Object());
        // Gdybyśmy mogli, napisalibyśmy taki kod:
//        List<?> unknownObjects2 = new ArrayList<Object>();
//        Object o = new String("X");
//        unknownObjects2.add(o);
        // Sytuacja jest inna w przypadku tablic — to jest całkiem dozwolone
        String[] words = {"Witaj, świecie!"};
        Object[] objects = words;

        // Teraz jednak możemy wpaść w błędy wykonawcze
        objects[0] = Integer.valueOf(42);
    }

    // Przykład metody generycznej - ekwiwalent operatora przecinka z języka Perl
    public static <T> T comma(T a, T b) {
        return a;
    }

    /**
     * @param args
     * @throws IOException 
     */
    public static void main(String[] args) throws IOException {
        instance = new GenericsExamples();
        instance.run();
    }

}
