package javanut8.ch04;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ScratchGenerics {

    private static ScratchGenerics instance = null;

    // Konstruktor
    public ScratchGenerics() {
        super();
    }

    private void run() {
		// Nie przejdzie kompilacji
//		List<Object> objects = new ArrayList<String>();
        // OK
        List<?> unknownObjects = new ArrayList<String>();

        Object o = new String("X");

        // To jest dozwolone
        String[] words = {"Hello World!"};
        Object[] objects = words;

        // Błąd wykonawczy
//		objects[0] = new Integer(42);
        class Local {

            public void foo() {
                System.out.println("Foo!");
            }
        }

        Local l = new Local();
        l.foo();

        File dir = new File("/src");      // Katalog do listy

        String[] filelist = dir.list((f, s) -> {
            return s.endsWith(".java");
        });

    }

    private void run2() {
        List<Cat> cats = new ArrayList<Cat>();
        List<? extends Pet> pets = cats;
//        pets.add(new Cat()); // nie przejdzie kompilacji
        cats.add(new Cat());
    }

    private void run3() {
        NumberBox<Integer> ni = new NumberBox<>();
        // nie przejdzie kompilacji
//        NumberBox<Object> no = new NumberBox<>();
        NumberBox n = new NumberBox();
        // niebezpieczne
        n.box(new Object());
        // błąd wykonawczy
        System.out.println(n.intValue());
        // ComparingBox<Object> cbo = new ComparingBox<>();
    }
    
    public static <T> T comma(T a, T b) {
        return a;
    }

    /**
     * @param args
     * @throws IOException 
     */
    public static void main(String[] args) throws IOException {
        instance = new ScratchGenerics();
        instance.run3();
    }

}
