package org.jpwh.test.advanced;

import org.jpwh.env.JPATest;
import org.jpwh.model.advanced.Bid;
import org.jpwh.model.advanced.Item;
import org.jpwh.model.advanced.ItemBidSummary;
import org.testng.annotations.Test;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.UserTransaction;
import java.math.BigDecimal;

import static org.testng.Assert.assertEquals;

public class MappedSubselect extends JPATest {

    @Override
    public void configurePersistenceUnit() throws Exception {
        configurePersistenceUnit("AdvancedPU");
    }

    @Test
    public void loadSubselectEntity() throws Exception {
        long ITEM_ID = storeItemAndBids();

        UserTransaction tx = TM.getUserTransaction();
        try {
            tx.begin();
            EntityManager em = JPA.createEntityManager();

            {
                ItemBidSummary itemBidSummary = em.find(ItemBidSummary.class, ITEM_ID);
                // select * from (
                //      select i.ID as ITEMID, i.ITEM_NAME as NAME, ...
                // ) where ITEMID = ?

                assertEquals(itemBidSummary.getName(), "AUCTION: Jakiś przedmiot");
            }
            em.clear();

            { // Hibernate przed odpytaniem zsynchronizuje odpowiednie tabele
                Item item = em.find(Item.class, ITEM_ID);
                item.setName("Nowa nazwa");

                //Brak synchronizacji przed pobraniem rekordu według identyfikatora
                // ItemBidSummary itemBidSummary = em.find(ItemBidSummary.class, ITEM_ID);

                //Automatyczna synchronizacja przed zapytaniami w przypadku, gdy zaktualizowano zsynchronizowane tabele
                Query query = em.createQuery(
                    "select ibs from ItemBidSummary ibs where ibs.itemId = :id"
                );
                ItemBidSummary itemBidSummary =
                    (ItemBidSummary)query.setParameter("id", ITEM_ID).getSingleResult();

                assertEquals(itemBidSummary.getName(), "AUKCJA: Nowa nazwa");
            }

            tx.commit();
            em.close();
        } finally {
            TM.rollback();
        }
    }

    public Long storeItemAndBids() throws Exception {
        UserTransaction tx = TM.getUserTransaction();
        tx.begin();
        EntityManager em = JPA.createEntityManager();
        Item item = new Item();
        item.setName("Jakiś przedmiot");
        item.setDescription("Jakiś opis.");
        em.persist(item);
        for (int i = 1; i <= 3; i++) {
            Bid bid = new Bid();
            bid.setAmount(new BigDecimal(10 + i));
            bid.setItem(item);
            em.persist(bid);
        }
        tx.commit();
        em.close();
        return item.getId();
    }

}
