package org.jpwh.test.fetching;

import org.hibernate.Hibernate;
import org.jpwh.env.JPATest;
import org.jpwh.model.fetching.interception.Item;
import org.jpwh.model.fetching.interception.User;
import org.jpwh.shared.util.CalendarUtil;
import org.jpwh.shared.util.TestData;
import org.testng.annotations.Test;

import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertTrue;

// TODO: Patrz model/pom.xml. Nowy ulepszacz kodu bajtowego nie działa poprawnie. Nie zobaczymy leniwego ładowania SQL tak, jak tu pokazaliśmy!
public class LazyInterception extends JPATest {

    @Override
    public void configurePersistenceUnit() throws Exception {
        configurePersistenceUnit("FetchingInterceptionPU");
    }

    public FetchTestData storeTestData() throws Exception {
        UserTransaction tx = TM.getUserTransaction();
        tx.begin();
        EntityManager em = JPA.createEntityManager();

        Long[] itemIds = new Long[3];
        Long[] userIds = new Long[3];

        User jandomanski = new User("jandomanski");
        em.persist(jandomanski);
        userIds[0] = jandomanski.getId();

        User janinadomanska = new User("janinadomanska");
        em.persist(janinadomanska);
        userIds[1] = janinadomanska.getId();

        User robertdomanski = new User("robertdomanski");
        em.persist(robertdomanski);
        userIds[2] = robertdomanski.getId();

        Item item = new Item("Przedmiot pierwszy", CalendarUtil.TOMORROW.getTime(), jandomanski, "Some description.");
        em.persist(item);
        itemIds[0] = item.getId();

        item = new Item("Przedmiot drugi", CalendarUtil.TOMORROW.getTime(), jandomanski, "Some description.");
        em.persist(item);
        itemIds[1] = item.getId();

        item = new Item("Przedmiot trzeci", CalendarUtil.AFTER_TOMORROW.getTime(), janinadomanska, "Some description.");
        em.persist(item);
        itemIds[2] = item.getId();

        tx.commit();
        em.close();

        FetchTestData testData = new FetchTestData();
        testData.items = new TestData(itemIds);
        testData.users = new TestData(userIds);
        return testData;
    }

    @Test
    public void noUserProxy() throws Exception {
        FetchTestData testData = storeTestData();

        UserTransaction tx = TM.getUserTransaction();
        try {
            tx.begin();
            EntityManager em = JPA.createEntityManager();

            Long ITEM_ID = testData.items.getFirstId();
            Long USER_ID = testData.users.getFirstId();

            {
                // Obiekty proxy są wyłaczone. Wywołanie getReference() zwróci zainicjowany egzemplarz
                User user = em.getReference(User.class, USER_ID);
                // select * from USERS where ID = ?

                assertTrue(Hibernate.isInitialized(user));
            }
            em.clear();

            {
                Item item = em.find(Item.class, ITEM_ID);
                // select * from ITEM where ID = ?

                assertEquals(item.getSeller().getId(), USER_ID);
                // select * from USERS where ID = ?
                // Nawet item.getSeller() wyswoli instrukcję SELECT!
            }

            tx.commit();
            em.close();
        } finally {
            TM.rollback();
        }
    }

    @Test
    public void lazyBasic() throws Exception {
        FetchTestData testData = storeTestData();

        UserTransaction tx = TM.getUserTransaction();
        try {
            tx.begin();
            EntityManager em = JPA.createEntityManager();

            Long ITEM_ID = testData.items.getFirstId();

            Item item = em.find(Item.class, ITEM_ID);
            // select NAME, AUCTIONEND, ... from ITEM where ID = ?

             // Dostęp do jednego ładuje wszystkie leniwe właściwości (description, seller, ...)
            assertTrue(item.getDescription().length() > 0);
            // select DESCRIPTION from ITEM where ID = ?
            // select * from USERS where ID = ?

            tx.commit();
            em.close();
        } finally {
            TM.rollback();
        }
    }


}
