package org.jpwh.web.dao;

import org.jpwh.web.model.Item;
import org.jpwh.web.model.ItemBidSummary;
import org.jpwh.web.model.Item_;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.util.List;

public class ItemDAOImpl
    extends GenericDAOImpl<Item, Long>
    implements ItemDAO {

    @Inject
    public ItemDAOImpl(EntityManager em) {
        super(em, Item.class);
    }

    @Override
    public List<ItemBidSummary> getItemBidSummaries(Page page) {

        /* 
            To jest standardowa kwerenda kryterium, którą widzieliśmy wielokrotnie wcześniej
         */
        CriteriaBuilder cb =
            getEntityManager().getCriteriaBuilder();

        CriteriaQuery<ItemBidSummary> criteria =
            cb.createQuery(ItemBidSummary.class);

        Root<Item> i = criteria.from(Item.class);

        // Kilka szczegółów kwerendy...
        criteria.select(cb.construct(
            ItemBidSummary.class,
            i.get(Item_.id),
            i.get(Item_.name),
            i.get(Item_.auctionEnd),
            i.get(Item_.maxBidAmount)
        ));

        /* 
            Delegat kończący zapytanie do wybranej strony.
         */
        TypedQuery<ItemBidSummary> query =
            page.createQuery(em, criteria, i);

        return query.getResultList();
    }

    @Override
    public BigDecimal getMaxBidAmount(Item item) {
        return (BigDecimal) getEntityManager().createNamedQuery("getMaxBidAmount")
            .setParameter("item", item)
            .getSingleResult();
    }
}

