package eventTracer;

import java.awt.*;
import java.beans.*;
import java.lang.reflect.*;

/**
 * @version 1.31 2004-05-10
 * @author Cay Horstmann
 */
public class EventTracer
{
   private InvocationHandler handler;

   public EventTracer()
   {
      // handler wszystkich obiektw porednich zdarze
      handler = new InvocationHandler()
         {
            public Object invoke(Object proxy, Method method, Object[] args)
            {
               System.out.println(method + ":" + args[0]);
               return null;
            }
         };
   }

   /**
    * Dodawanie obiektw ledzcych zdarzenia dla wszystkich zdarze, ktrych ten komponent i jego potomkowie mog nasuchiwa
    * @param c a component
    */
   public void add(Component c)
   {
      try
      {
         // Pobranie wszystkich zdarze, ktrych ten komponent moe nasuchiwa
         BeanInfo info = Introspector.getBeanInfo(c.getClass());

         EventSetDescriptor[] eventSets = info.getEventSetDescriptors();
         for (EventSetDescriptor eventSet : eventSets)
            addListener(c, eventSet);
      }
      catch (IntrospectionException e)
      {
      }
      // W razie wystpienia wyjtku nie dodawa suchaczy

      if (c instanceof Container)
      {
         // Pobranie wszystkich potomkw i rekursywne wywoanie metody add
         for (Component comp : ((Container) c).getComponents())
            add(comp);
      }
   }

   /**
    * Dodanie suchacza do danego zbioru zdarze
    * @param c a komponent
    * @param eventSet deskryptor interfejsu nasuchujcego
    */
   public void addListener(Component c, EventSetDescriptor eventSet)
   {
      // Utworzenie obiektu poredniego dla tego typu suchaczy i przekazanie wszystkich wywoa do handlera

      Object proxy = Proxy.newProxyInstance(null, new Class[] { eventSet.getListenerType() },
            handler);

      // Dodanie obiektu poredniego jako suchacza do komponentu
      Method addListenerMethod = eventSet.getAddListenerMethod();
      try
      {
         addListenerMethod.invoke(c, proxy);
      }
      catch (ReflectiveOperationException e)
      {
      }
      // W razie wystpienia wyjtku nie dodawa suchaczy
   }
}
