package dataExchange;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Ramka z menu, ktrego akcja Plik->Pocz wywietla okno dialogowe z polem hasa
 */
public class DataExchangeFrame extends JFrame
{
   public static final int TEXT_ROWS = 20;
   public static final int TEXT_COLUMNS = 40;
   private PasswordChooser dialog = null;
   private JTextArea textArea;

   public DataExchangeFrame()
   {
      // Tworzenie menu Plik

      JMenuBar mbar = new JMenuBar();
      setJMenuBar(mbar);
      JMenu fileMenu = new JMenu("Plik");
      mbar.add(fileMenu);

      // Tworzenie elementw menu Pocz i Zamknij

      JMenuItem connectItem = new JMenuItem("Pocz");
      connectItem.addActionListener(new ConnectAction());
      fileMenu.add(connectItem);

      // Opcja Zamknij zamyka program

      JMenuItem exitItem = new JMenuItem("Zamknij");
      exitItem.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               System.exit(0);
            }
         });
      fileMenu.add(exitItem);

      textArea = new JTextArea(TEXT_ROWS, TEXT_COLUMNS);
      add(new JScrollPane(textArea), BorderLayout.CENTER);
      pack();
   }

   /**
    * Akcja Connect wywietla okno dialogowe z polem hasa
    */

   private class ConnectAction implements ActionListener
   {
      public void actionPerformed(ActionEvent event)
      {
         // Jeli jest to pierwszy raz, tworzy okno dialogowe

         if (dialog == null) dialog = new PasswordChooser();

         // Ustawianie wartoci domylnych
         dialog.setUser(new User("yourname", null));

         // Wywietlenie okna dialogowego
         if (dialog.showDialog(DataExchangeFrame.this, "Connect"))
         {
            // Pobranie danych uytkownika w przypadku zatwierdzenia
            User u = dialog.getUser();
            textArea.append("nazwa uytkownika = " + u.getName() + ", haso = "
                  + (new String(u.getPassword())) + "\n");
         }
      }
   }
}