/*
 * Decompiled with CFR 0.152.
 */
package webstart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class CalculatorPanel
extends JPanel {
    private JTextArea display;
    private JPanel panel;
    private double result;
    private String lastCommand;
    private boolean start;

    public CalculatorPanel() {
        this.setLayout(new BorderLayout());
        this.result = 0.0;
        this.lastCommand = "=";
        this.start = true;
        this.display = new JTextArea(10, 20);
        this.add((Component)new JScrollPane(this.display), "North");
        InsertAction insertAction = new InsertAction();
        CommandAction commandAction = new CommandAction();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(4, 4));
        this.addButton("7", insertAction);
        this.addButton("8", insertAction);
        this.addButton("9", insertAction);
        this.addButton("/", commandAction);
        this.addButton("4", insertAction);
        this.addButton("5", insertAction);
        this.addButton("6", insertAction);
        this.addButton("*", commandAction);
        this.addButton("1", insertAction);
        this.addButton("2", insertAction);
        this.addButton("3", insertAction);
        this.addButton("-", commandAction);
        this.addButton("0", insertAction);
        this.addButton(".", insertAction);
        this.addButton("=", commandAction);
        this.addButton("+", commandAction);
        this.add((Component)this.panel, "Center");
    }

    public String getText() {
        return this.display.getText();
    }

    public void append(String string) {
        this.display.append(string);
    }

    private void addButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        this.panel.add(jButton);
    }

    public void calculate(double d) {
        if (this.lastCommand.equals("+")) {
            this.result += d;
        } else if (this.lastCommand.equals("-")) {
            this.result -= d;
        } else if (this.lastCommand.equals("*")) {
            this.result *= d;
        } else if (this.lastCommand.equals("/")) {
            this.result /= d;
        } else if (this.lastCommand.equals("=")) {
            this.result = d;
        }
    }

    private class CommandAction
    implements ActionListener {
        private CommandAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (CalculatorPanel.this.start) {
                if (string.equals("-")) {
                    CalculatorPanel.this.display.append(string);
                    CalculatorPanel.this.start = false;
                } else {
                    CalculatorPanel.this.lastCommand = string;
                }
            } else {
                try {
                    int n = CalculatorPanel.this.display.getLineCount();
                    int n2 = CalculatorPanel.this.display.getLineStartOffset(n - 1);
                    int n3 = CalculatorPanel.this.display.getLineEndOffset(n - 1);
                    String string2 = CalculatorPanel.this.display.getText(n2, n3 - n2);
                    CalculatorPanel.this.display.append(" ");
                    CalculatorPanel.this.display.append(string);
                    CalculatorPanel.this.calculate(Double.parseDouble(string2));
                    if (string.equals("=")) {
                        CalculatorPanel.this.display.append("\n" + CalculatorPanel.this.result);
                    }
                    CalculatorPanel.this.lastCommand = string;
                    CalculatorPanel.this.display.append("\n");
                    CalculatorPanel.this.start = true;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    private class InsertAction
    implements ActionListener {
        private InsertAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            CalculatorPanel.this.start = false;
            CalculatorPanel.this.display.append(string);
        }
    }
}

