import java.awt.*;

import javax.swing.*;

/**
 * @version 1.32 2007-04-14
 * @author Cay Horstmann
 */
public class SizedFrameTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               SizedFrame frame = new SizedFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

class SizedFrame extends JFrame
{
   public SizedFrame()
   {
      // Sprawdzenie wymiarw ekranu.

      Toolkit kit = Toolkit.getDefaultToolkit();
      Dimension screenSize = kit.getScreenSize();
      int screenHeight = screenSize.height;
      int screenWidth = screenSize.width;

      // Ustawienie szerokoci i wysokoci ramki oraz polecenie systemowi, aby ustali jej pooenie.

      setSize(screenWidth / 2, screenHeight / 2);
      setLocationByPlatform(true);

      // Ustawienie ikony i tytuu.

      Image img = kit.getImage("icon.gif");
      setIconImage(img);
      setTitle("SizedFrame");
   }
}
