import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;

/**
 * @version 1.03 2007-06-12
 * @author Cay Horstmann
 */
public class RobotTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               // Ramka z panelem zawierajcym przycisk.

               ButtonFrame frame = new ButtonFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);

               // Powizanie robota z ekranem.

               GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
               GraphicsDevice screen = environment.getDefaultScreenDevice();

               try
               {
                  Robot robot = new Robot(screen);
                  runTest(robot);
               }
               catch (AWTException e)
               {
                  e.printStackTrace();
               }
            }
         });
   }

   /**
    * Uruchamia procedur testow.
    * @param robot robot zwizany z ekranem
    */
   public static void runTest(Robot robot)
   {
      // Symulacja nacinicia spacji.
      robot.keyPress(' ');
      robot.keyRelease(' ');

      // Symulacja nacinicia klawisza Tab i spacji.
      robot.delay(2000);
      robot.keyPress(KeyEvent.VK_TAB);
      robot.keyRelease(KeyEvent.VK_TAB);
      robot.keyPress(' ');
      robot.keyRelease(' ');

      // Symulacja kliknicia mysz prawego przycisku w oknie.
      robot.delay(2000);
      robot.mouseMove(200, 50);
      robot.mousePress(InputEvent.BUTTON1_MASK);
      robot.mouseRelease(InputEvent.BUTTON1_MASK);

      // Zrobienie zrzutu ekranu i wywietlenie obrazu.
      robot.delay(2000);
      BufferedImage image = robot.createScreenCapture(new Rectangle(0, 0, 400, 300));

      ImageFrame frame = new ImageFrame(image);
      frame.setVisible(true);
   }
}

/**
 * Ramka zawierajca wywietlany obraz.
 */
class ImageFrame extends JFrame
{
   /**
    * @param image obraz do wywietlenia
    */
   public ImageFrame(Image image)
   {
      setTitle("Zrzut ekranu");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      JLabel label = new JLabel(new ImageIcon(image));
      add(label);
   }

   public static final int DEFAULT_WIDTH = 450;
   public static final int DEFAULT_HEIGHT = 350;
}
