import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;

/**
   Panel zawierajcy przyciski kalkulatora i wywietlacz wynikw.
*/
public class CalculatorPanel extends JPanel
{  
   /**
      Rozkad panelu.
   */
   public CalculatorPanel()
   {  
      setLayout(new BorderLayout());

      result = 0;
      lastCommand = "=";
      start = true;
      
      // Dodanie wywietlacza.

      display = new JTextArea(10, 20);

      add(new JScrollPane(display), BorderLayout.NORTH);
      
      ActionListener insert = new InsertAction();
      ActionListener command = new CommandAction();

      // Dodanie przyciskw na siatce 4 x 4.

      panel = new JPanel();
      panel.setLayout(new GridLayout(4, 4));

      addButton("7", insert);
      addButton("8", insert);
      addButton("9", insert);
      addButton("/", command);

      addButton("4", insert);
      addButton("5", insert);
      addButton("6", insert);
      addButton("*", command);

      addButton("1", insert);
      addButton("2", insert);
      addButton("3", insert);
      addButton("-", command);

      addButton("0", insert);
      addButton(".", insert);
      addButton("=", command);
      addButton("+", command);

      add(panel, BorderLayout.CENTER);
   }

   /**
      Tekst historii.
      @return historia kalkulatora
   */
   public String getText()
   {
      return display.getText();
   }
   
   /**
      Docza acuch do tekstu historii.
      @param s acuch, ktry naley doczy
   */
   public void append(String s)
   {
      display.append(s);
   }

   /**
      Dodaje przycisk do rodkowego panelu.
      @param label etykieta przycisku
      @param listener suchacz przycisku
   */
   private void addButton(String label, ActionListener listener)
   {  
      JButton button = new JButton(label);
      button.addActionListener(listener);
      panel.add(button);
   }

   /**
      Wstawia acuch akcji przycisku na
      kocu wywietlanego tekstu.
   */
   private class InsertAction implements ActionListener
   {
      public void actionPerformed(ActionEvent event)
      {
         String input = event.getActionCommand();
         start = false;
         display.append(input);
      }
   }

   /**
      Niniejsza akcja wykonuje polecenie okrelane
      przez acuch akcji przycisku.
   */
   private class CommandAction implements ActionListener
   {
      public void actionPerformed(ActionEvent event)
      {  
         String command = event.getActionCommand();

         if (start)
         {  
            if (command.equals("-")) 
            { 
               display.append(command); 
               start = false; 
            }
            else 
               lastCommand = command;
         }
         else
         {  
            try
            {
               int lines = display.getLineCount();
               int lineStart = display.getLineStartOffset(lines - 1);
               int lineEnd = display.getLineEndOffset(lines - 1);
               String value = display.getText(lineStart, lineEnd - lineStart);
               display.append(" ");
               display.append(command); 
               calculate(Double.parseDouble(value));
               if (command.equals("="))
                  display.append("\n" + result);
               lastCommand = command;
               display.append("\n");
               start = true;
            }
            catch (BadLocationException e)
            {
               e.printStackTrace();
            }
         }
      }
   }

   /**
      Wykonuje oczekujce obliczenia. 
      @param x warto, ktra ma zosta zsumowana z poprzednim wynikiem
   */
   public void calculate(double x)
   {
      if (lastCommand.equals("+")) result += x;
      else if (lastCommand.equals("-")) result -= x;
      else if (lastCommand.equals("*")) result *= x;
      else if (lastCommand.equals("/")) result /= x;
      else if (lastCommand.equals("=")) result = x;
   }
   
   private JTextArea display;
   private JPanel panel;
   private double result;
   private String lastCommand;
   private boolean start;
}