import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * @version 1.33 2007-06-12
 * @author Cay Horstmann
 */
public class DialogTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(new Runnable()
         {
            public void run()
            {
               DialogFrame frame = new DialogFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            }
         });
   }
}

/**
 * Ramka z menu, ktrego akcja Plik->O programie wywietla okno dialogowe.
 */
class DialogFrame extends JFrame
{
   public DialogFrame()
   {
      setTitle("DialogTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // Tworzenie menu Plik

      JMenuBar menuBar = new JMenuBar();
      setJMenuBar(menuBar);
      JMenu fileMenu = new JMenu("Plik");
      menuBar.add(fileMenu);

      // Tworzenie elementw O programie i Zamknij

      // Element O programie wywietla okno dialogowe O programie

      JMenuItem aboutItem = new JMenuItem("O programie");
      aboutItem.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               if (dialog == null) // pierwszy raz
               dialog = new AboutDialog(DialogFrame.this);
               dialog.setVisible(true); // wyskakujce okno dialogowe
            }
         });
      fileMenu.add(aboutItem);

      // Element Zamknij powoduje zamknicie programu.

      JMenuItem exitItem = new JMenuItem("Zamknij");
      exitItem.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               System.exit(0);
            }
         });
      fileMenu.add(exitItem);
   }

   public static final int DEFAULT_WIDTH = 300;
   public static final int DEFAULT_HEIGHT = 200;

   private AboutDialog dialog;
}

/**
 * Przykadowe modalne okno dialogowe wywietlajce komunikat i oczekujce na kliknicie przycisku Ok.
 */
class AboutDialog extends JDialog
{
   public AboutDialog(JFrame owner)
   {
      super(owner, "Test okna O programie", true);

      // Dodanie etykiety w HTML

      add(
            new JLabel(
                  "<html><h1><i>Core Java</i></h1><hr>By Cay Horstmann and Gary Cornell</html>"),
            BorderLayout.CENTER);

      // Przycisk Ok zamyka okno dialogowe.

      JButton ok = new JButton("Ok");
      ok.addActionListener(new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               setVisible(false);
            }
         });

      // Dodanie przycisku Ok przy krawdzi poudniowej.

      JPanel panel = new JPanel();
      panel.add(ok);
      add(panel, BorderLayout.SOUTH);

      setSize(250, 150);
   }
}
