import java.util.*;

/**
 * Niniejszy program demonstruje klasy abstrakcyjne.
 * @version 1.01 2004-02-21
 * @author Cay Horstmann
 */
public class PersonTest
{
   public static void main(String[] args)
   {
      Person[] people = new Person[2];

      // Wstawienie do tablicy people obiektw Student i Employee.
      people[0] = new Employee("Henryk Kwiatek", 50000, 1989, 10, 1);
      people[1] = new Student("Maria Mrozowska", "informatyka");

      // Drukowanie imion i nazwisk oraz opisw wszystkich obiektw klasy Person.
      for (Person p : people)
         System.out.println(p.getName() + ", " + p.getDescription());
   }
}

abstract class Person
{
   public Person(String n)
   {
      name = n;
   }

   public abstract String getDescription();

   public String getName()
   {
      return name;
   }

   private String name;
}

class Employee extends Person
{
   public Employee(String n, double s, int year, int month, int day)
   {
      super(n);
      salary = s;
      GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day);
      hireDay = calendar.getTime();
   }

   public double getSalary()
   {
      return salary;
   }

   public Date getHireDay()
   {
      return hireDay;
   }

   public String getDescription()
   {
      return String.format("pracownik zarabiajcy  %.2f z", salary);
   }

   public void raiseSalary(double byPercent)
   {
      double raise = salary * byPercent / 100;
      salary += raise;
   }

   private double salary;
   private Date hireDay;
}

class Student extends Person
{
   /**
    * @param n imi i nazwisko studenta
    * @param m specjalizacja studenta
    */
   public Student(String n, String m)
   {
      // Przekazanie n do konstruktora nadklasy.
      super(n);
      major = m;
   }

   public String getDescription()
   {
      return "student specjalizacji " + major;
   }

   private String major;
}
