package localInnerClass;

import java.awt.*;
import java.awt.event.*;
import java.time.*;

import javax.swing.*;

/**
 * Ten program demonstruje sposb uycia lokalnych klas wewntrznych.
 * @version 1.02 2017-12-14
 * @author Cay Horstmann
 */
public class LocalInnerClassTest
{
   public static void main(String[] args)
   {
      var clock = new TalkingClock();
      clock.start(1000, true); 
      
      // Niech program dziaa, dopki uytkownik nie wcinie przycisku OK.
      JOptionPane.showMessageDialog(null, "Zamkn program?");
      System.exit(0);
   }
}

/**
 * Zegar drukujcy informacje o czasie w rwnych odstpach czasu.
 */
class TalkingClock
{
    /**
    * Wczanie zegara.
    * @param interval odstp czasu pomidzy kolejnymi komunikatami (w milisekundach)
    * @param beep warto true oznacza, e dwik ma by odtwarzany
    */
   public void start(int interval, boolean beep)
   {
      class TimePrinter implements ActionListener
      {
         public void actionPerformed(ActionEvent event)
         {
            System.out.println("Kiedy usyszysz dwik, bdzie godzina " 
                  + Instant.ofEpochMilli(event.getWhen()));
            if (beep) Toolkit.getDefaultToolkit().beep();
         }
      }
      var listener = new TimePrinter();
      var timer = new Timer(interval, listener);
      timer.start();
   }
}
