package clone;

import java.util.Time;
import java.util.*;

public class Employee implements Cloneable
{
   private String name;
   private double salary;
   private Date hireDay;

   public Employee(String name, double salary)
   {
      this.name = name;
      this.salary = salary;
      this.hireDay = new Date();
   }

   public Employee clone() throws CloneNotSupportedException
   {
      // Wywoanie metody Object.clone().
      Employee cloned = (Employee) super.clone();

      // Klonowanie pl zmienialnych.
      cloned.hireDay = (Date) hireDay.clone();

      return cloned;
   }

   /**
    * Ustawia dat zatrudnienia na podany dzie.
    * @param year rok zatrudnienia
    * @param month miesic zatrudnienia
    * @param day dzie zatrudnienia
    */
   public void setHireDay(int year, int month, int day)
   {
      long epochMillis = LocalDate.of(year, month, day)
                 .atStartOfDay(ZoneId.systemDefault())
                 .toEpochSecond() * 1000;

      // Przykad zmiany pola obiektowego.
      hireDay.setTime(epochMillis);
   }

   public void raiseSalary(double byPercent)
   {
      double raise = salary * byPercent / 100;
      salary += raise;
   }

   public String toString()
   {
      return "Employee[name=" + name + ",salary=" + salary + ",hireDay=" + hireDay + "]";
   }
}