package threads;

import java.util.*;

/**
 * Bank z pewn liczb kont.
 */
public class Bank
{
   private final double[] accounts;

   /**
    * Tworzy bank.
    * @param n liczba kont
    * @param initialBalance pocztkowe saldo kadego konta
    */
   public Bank(int n, double initialBalance)
   {
      accounts = new double[n];
      Arrays.fill(accounts, initialBalance);
   }

   /**
    * Przelewa pienidze z jednego konta na inne.
    * @param from konto rdowe
    * @param to konto docelowe
    * @param amount kwota przelewu
    */
   public void transfer(int from, int to, double amount)
   {
      if (accounts[from] < amount) return;
      System.out.print(Thread.currentThread());
      accounts[from] -= amount;
      System.out.printf(" %10.2f z %d na %d", amount, from, to);
      accounts[to] += amount;
      System.out.printf(" Saldo cakowite: %10.2f%n", getTotalBalance());
   }

   /**
    * Oblicza sum wszystkich sald kont.
    * @return saldo cakowite
    */
   public double getTotalBalance()
   {
      double sum = 0;

      for (double a : accounts)
         sum += a;

      return sum;
   }

   /**
    * Sprawdza liczb kont w banku.
    * @return liczba kont
    */
   public int size()
   {
      return accounts.length;
   }
}
