package anonymousInnerClass;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.Timer;

/**
 * Ten program demonstruje zastosowanie anonimowych klas wewntrznych.
 * @version 1.11 2015-05-12
 * @author Cay Horstmann
 */
public class AnonymousInnerClassTest
{
   public static void main(String[] args)
   {
      var clock = new TalkingClock();
      clock.start(1000, true);

      // Niech program dziaa, dopki uytkownik nie wcinie przycisku OK.
      JOptionPane.showMessageDialog(null, "Zamkn program?");
      System.exit(0);
   }
}

/**
 * Zegar drukujcy informacje o czasie w rwnych odstpach czasu.
 */
class TalkingClock
{
   /**
    * Uruchamia zegar.
    * @param interval odstp czasu pomidzy kolejnymi komunikatami (w milisekundach)
    * @param beep warto true oznacza, e dwik ma by odtwarzany
    */
   public void start(int interval, boolean beep)
   {
      ActionListener listener = new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               System.out.println("Kiedy usyszysz dwik, bdzie godzina " + Instant.ofEpochMilli(event.getWhen()));
               if (beep) Toolkit.getDefaultToolkit().beep();
            }
         };
      var timer = new Timer(interval, listener);
      timer.start();
   }
}
