import java.util.*;

/**
 * Ten program demonstruje techniki konstrukcji obiektw.
 * @version 1.02 2018-04-10
 * @author Cay Horstmann
 */
public class ConstructorTest
{
   public static void main(String[] args)
   {
      // Wstawienie do tablic staff trzech obiektw klasy Employee.
      var staff = new Employee[3];

      staff[0] = new Employee("Hubert", 40000);
      staff[1] = new Employee(60000);
      staff[2] = new Employee();

      // Wydruk informacji o wszystkich obiektach klasy Employee.
      for (Employee e : staff)
         System.out.println("name=" + e.getName() + ",id=" + e.getId() + ",salary="
               + e.getSalary());
   }
}

class Employee
{
   private static int nextId;

   private int id;
   private String name = "";   // Inicjalizacja zmiennej skadowej obiektu.
   private double salary;

   private static Random generator = new Random();

   // Statyczny blok inicjujcy.
   static
   {
      // Ustawienie zmiennej nextId na losow liczb cakowit z przedziau 0  9999.
      nextId = generator.nextInt(10000);
   }

   // Blok inicjujcy obiektw.
   {
      id = nextId;
      nextId++;
   }

   // Trzy konstruktory przecione.
   public Employee(String n, double s)
   {
      name = n;
      salary = s;
   }

   public Employee(double s)
   {
      // Wywoanie konstruktora Employee(String, double).
      this("Employee #" + nextId, s);
   }

   // Konstruktor domylny.
   public Employee()
   {
      // Zmienna name zainicjalizowana wartoci ""  patrz niej.
      // Zmienna salary nie jest jawnie ustawiona  inicjalizacja wartoci 0.
      // Zmienna id jest inicjalizowana w bloku inicjujcym.
   }

   public String getName()
   {
      return name;
   }

   public double getSalary()
   {
      return salary;
   }

   public int getId()
   {
      return id;
   }
}