package sizedFrame;

import java.awt.*;
import javax.swing.*;

/**
 * @version 1.33 2007-05-12
 * @author Cay Horstmann
 */
public class SizedFrameTest
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(() ->
         {
            JFrame frame = new SizedFrame();
            frame.setTitle("SizedFrame");
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setVisible(true);
         });
   }
}

class SizedFrame extends JFrame
{
   public SizedFrame()
   {
      // Sprawdzenie wymiarw ekranu.

      Toolkit kit = Toolkit.getDefaultToolkit();
      Dimension screenSize = kit.getScreenSize();
      int screenHeight = screenSize.height;
      int screenWidth = screenSize.width;

      // Ustawienie szerokoci i wysokoci ramki oraz polecenie systemowi, aby ustali jej pooenie.

      setSize(screenWidth / 2, screenHeight / 2);
      setLocationByPlatform(true);

      // Ustawienie ikony ramki.

      Image img = new ImageIcon("icon.gif").getImage();
      setIconImage(img);      
   }
}
