package plaf;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/**
 * Ramka z panelem zawierajcym przyciski zmieniajce styl.
 */
public class PlafFrame extends JFrame
{
   private JPanel buttonPanel;

   public PlafFrame()
   {
      buttonPanel = new JPanel();

      UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
      for (UIManager.LookAndFeelInfo info : infos)
         makeButton(info.getName(), info.getClassName());

      add(buttonPanel);
      pack();
   }

   /**
    * Tworzy przycisk zmieniajcy styl.
    * @param name nazwa przycisku
    * @param plafName nazwa klasy stylu
    */
   private void makeButton(String name, String className)
   {
      // Dodanie przycisku do panelu.

      JButton button = new JButton(name);
      buttonPanel.add(button);

      // Ustawienie akcji przycisku.

      button.addActionListener(event -> {
         // Akcja przycisku  przeczenie na nowy styl.
         try
         {
            UIManager.setLookAndFeel(className);
            SwingUtilities.updateComponentTreeUI(this);
            pack();
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
      });
   }
}
