package innerClass;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.Timer;

/**
 * Niniejszy program demonstruje sposb uycia klas wewntrznych.
 * @version 1.10 2004-02-27
 * @author Cay Horstmann
 */
public class InnerClassTest
{
   public static void main(String[] args)
   {
      TalkingClock clock = new TalkingClock(1000, true);
      clock.start();

      // Niech program dziaa, dopki uytkownik nie wcinie przycisku OK.
      JOptionPane.showMessageDialog(null, "Zamkn program?");
      System.exit(0);
   }
}

/**
 * Zegar drukujcy informacje o czasie w rwnych odstpach czasu.
 */
class TalkingClock
{
   private int interval;
   private boolean beep;

   /**
    * Tworzy obiekt TalkingClock.
    * @param interval odstp czasu pomidzy kolejnymi komunikatami (w milisekundach)
    * @param beep warto true oznacza, e dwik ma by odtwarzany
    */
   public TalkingClock(int interval, boolean beep)
   {
      this.interval = interval;
      this.beep = beep;
   }

   /**
    * Wczanie zegara.
    */
   public void start()
   {
      ActionListener listener = new TimePrinter();
      Timer t = new Timer(interval, listener);
      t.start();
   }

   public class TimePrinter implements ActionListener
   {
      public void actionPerformed(ActionEvent event)
      {
         System.out.println("Kiedy usyszysz dwik, bdzie godzina " + new Date());
         if (beep) Toolkit.getDefaultToolkit().beep();
      }
   }
}